#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define SIZE 10

int tab_find_min_index(int i, int size, char tab[size]) {
    int i_min = i;
    for (int j = i + 1; j < (int)strlen(tab); ++j) {
        if (tab[j] < tab[i_min]) {
            i_min = j;
        }
    }
    return i_min;
}

void swap(int i, int j, char tab[]) {
    char tmp = tab[i];
    tab[i] = tab[j];
    tab[j] = tmp;
}

void tab_selection_sort(int size, char tab[size]) {
    for (int i = 0; i < (int)strlen(tab); ++i) {
        int i_min = tab_find_min_index(i, size, tab);

        // échange tab[i] et tab[j]
        if (i_min != i) {
            swap(i, i_min, tab);
        }
    }
}

bool tab_is_sorted(int size, char tab[size]) {
    for (int i = 1; i < size; ++i) {
        if (tab[i - 1] > tab[i]) {
            return false;
        }
    }
    return true;
}

int main() {
    // allocate tab
    char tab_lhs[SIZE] = "tutut";
    char tab_rhs[SIZE] = "tutta";
    printf("Are %s and %s anagrams? ", tab_lhs, tab_rhs);
    tab_selection_sort(SIZE, tab_lhs);
    tab_selection_sort(SIZE, tab_rhs);
    printf("Are %s and %s anagrams? ", tab_lhs, tab_rhs);
    int is_equal = strcmp(tab_lhs, tab_rhs);
    printf("%d", is_equal);
}
