#include <stdio.h>

double pow_naive(double x, int n) {
    if (n == 0) {
        return 1.0;
    }
    double res = x;
    for (int i = 1; i < n; i++) {
        res *= x;
    }
    return res;
}

double pow_rec(double x, int n) {
    if (n == 0) {
        return 1.0;
    } else {
        return x * pow_rec(x, n - 1);
    }
}

double pow_eff(double x, int n) {
    if (n == 0) {
        return 1.0;
    } else if (n % 2 == 0) {
        double intermediate = pow_eff(x, n / 2);
        return intermediate * intermediate;
    } else {
        return x * pow_eff(x, n - 1);
    }
}

int main() {
    double x = 2;
    int n = 10000;
    double y = 0;
    for (int i = 0; i < 1000; ++i) {
        // y += pow_eff(x, n);
        y += pow_naive(x, n);
    }

    // printf("%lf^%d = %lf\n", x, n, pow_naive(x, n));
    // printf("%d^%d = %lf\n", x, n, pow_rec(x, n));
    // printf("%lf^%d = %lf\n", x, n, pow_eff(x, n));
    printf("y = %lf\n", y);
}
