#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>
#include <time.h>

#define SIZE 10

void tab_initialize(int size, double tab[size]) {
    srand(time(NULL));
    for (int i = 0; i < size; ++i) {
        double rdm = (double)rand() / (double)RAND_MAX;
        tab[i] = rdm;
    }
}

void tab_show(int size, double tab[size]) {
    for (int i = 0; i < size; ++i) {
        printf("%lf ", tab[i]);
    }
    printf("\n");
}

int tab_find_min_index(int i, int size, double tab[size]) {
    int i_min = i;
    for (int j = i + 1; j < size; ++j) {
        if (tab[j] < tab[i_min]) {
            i_min = j;
        }
    }
    return i_min;
}

void swap(int i, int j, double tab[]) {
    double tmp = tab[i];
    tab[i] = tab[j];
    tab[j] = tmp;
}

void tab_selection_sort(int size, double tab[size]) {
    for (int i = 0; i < size; ++i) {
        int i_min = tab_find_min_index(i, size, tab);

        // échange tab[i] et tab[j]
        if (i_min != i) {
            swap(i, i_min, tab);
        }
    }
}

bool tab_is_sorted(int size, double tab[size]) {
    for (int i = 1; i < size; ++i) {
        if (tab[i - 1] > tab[i]) {
            return false;
        }
    }
    return true;
}

int main() {
    // allocate tab
    double tab[SIZE];
    tab_initialize(SIZE, tab);
    tab_show(SIZE, tab);
    tab_selection_sort(SIZE, tab);
    tab_show(SIZE, tab);
    bool is_sorted = tab_is_sorted(SIZE, tab);
    printf("Is the tab sorted? %d\n", is_sorted);
}
