#ifndef HM_H
#define HM_H

#include <stdbool.h>

#define MAX_LEN 80

typedef enum {occupied, empty, deleted} state_t;

struct cell_t {
    char key[MAX_LEN];
    char value[MAX_LEN];
    state_t state;
};

struct hm_t {
    struct cell_t *table;
    int size;
    int capacity;
};

// allocate memory of the table to capacity
void hm_init(struct hm_t *hm, int capacity);

// insert the key - value pair: if key is already present
// we erase the old value. if the table is full we return false
bool hm_insert(struct hm_t *hm, char *key, char *value);

// changes the state of the table at the "key" position to deleted
void hm_delete(struct hm_t *hm, char *key);

// returns the value linked to the key if present
// return NULL otherwise
char *hm_get(struct hm_t hm, char *key);

// prints the state of the table
void hm_print(struct hm_t hm);

// frees ressources
void hm_destroy(struct hm_t *hm);

#endif // !HM_H
