#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <assert.h>

#define MAX_CAPACITY 5

struct stack {
    int top;
    int data[MAX_CAPACITY];
};

void stack_init(struct stack *s) {
    s->top = -1;
}

bool stack_is_empty(struct stack s) {
    return s.top == -1;
}

void stack_push(struct stack *s, int val) {
    assert(s->top < MAX_CAPACITY - 1);
    if (s->top != MAX_CAPACITY - 1) {
        s->top += 1;
        s->data[s->top] = val;
    }
}

/*int stack_pop(struct stack *s) {*/
/*    if (!stack_is_empty(*s)) {*/
/*        int tmp = s->data[s->top];*/
/*        s->top -= 1;*/
/*        return tmp;*/
/*    }*/
/*}*/

/*void stack_pop(struct stack *s, int *val) {*/
/*    if (!stack_is_empty(*s)) {*/
/*        *val = s->data[s->top];*/
/*        s->top -= 1;*/
/*    }*/
/*}*/

int *stack_pop(struct stack *s) {
    assert(!stack_is_empty(*s));

    if (!stack_is_empty(*s)) {
        int *val = &(s->data[s->top]);
        s->top -= 1;
        return val;
    } else {
        return NULL;
    }
}

int *stack_peek(struct stack s) {
    if (!stack_is_empty(s)) {
        int *val = &(s.data[s.top]);
        return val;
    } else {
        return NULL;
    }
}

void stack_print(struct stack s) {
    for (int i = s.top; i >= 0; --i) {
        printf("%d\n", s.data[i]);
    }
}

int main() {
    struct stack s;
    stack_init(&s);
    stack_print(s);

    printf("s.top = %d\n", s.top);
    printf("is_empty(): %s\n", stack_is_empty(s) ? "True" : "False");
    stack_push(&s, 10);
    stack_push(&s, 20);
    stack_push(&s, 30);
    stack_push(&s, 40);
    stack_push(&s, 50);
    stack_push(&s, 60);
    printf("is_empty(): %s\n", stack_is_empty(s) ? "True" : "False");
    stack_print(s);
    /*int val = -1;*/
    /*stack_pop(&s, &val);*/
    /*printf("popped value = %d\n", val);*/
    /*stack_pop(&s, &val);*/
    /*printf("popped value = %d\n", val);*/
    /*stack_pop(&s, &val);*/
    /*printf("popped value = %d\n", val);*/
    /*stack_pop(&s, &val);*/
    /*printf("popped value = %d\n", val);*/
    /*stack_pop(&s, &val);*/
    /*printf("popped value = %d\n", val);*/
    /*stack_pop(&s, &val);*/
    /*printf("popped value = %d\n", val);*/

    /*printf("popped value = %d\n", stack_pop(&s));*/
    /*printf("popped value = %d\n", stack_pop(&s));*/
    /*printf("popped value = %d\n", stack_pop(&s));*/
    /*printf("popped value = %d\n", stack_pop(&s));*/
    /*printf("popped value = %d\n", stack_pop(&s));*/
    /*printf("popped value = %d\n", stack_pop(&s));*/

    printf("peeked value = %d\n", *stack_peek(s));
    printf("peeked value = %d\n", *stack_peek(s));
    stack_print(s);

    printf("popped value = %d\n", *stack_pop(&s));
    printf("popped value = %d\n", *stack_pop(&s));
    printf("popped value = %d\n", *stack_pop(&s));
    printf("popped value = %d\n", *stack_pop(&s));
    printf("popped value = %d\n", *stack_pop(&s));
    /*printf("popped value = %d\n", *stack_pop(&s));*/
    stack_print(s);
    printf("is_empty(): %s\n", stack_is_empty(s) ? "True" : "False");

    return EXIT_SUCCESS;
}
