/* Author : Dario GENGA
 * Date : 15.11.2021
 * Description : Manipulate an unidimensional array with dynamic memory allocation
 */
#include "unidimensional_array.h"
#include "time.h"
#define USER_MODE 0
#define COMPUTER_MODE 1
#define MAX_RANDOM_VALUE 10

void execute(int mode) {
    size_t cycle_number = 3;
    size_t value = 0;
    size_t multiply_value = 0;
    size_t array_size;

    if (mode == USER_MODE) {
        // Ask the user the size of the array
       array_size = ask_array_size();
    } else if (mode == COMPUTER_MODE){
        array_size = rand() % MAX_RANDOM_VALUE + 1;
    }
    int *array = malloc(array_size * sizeof(int));

    // Fill the array with random values
    fill_array_with_random_values(array, array_size);

    // Print the array
    printf("Original array :\n");
    print_array(array, array_size);

    // Shuffle the array
    shuffle_array(array, array_size);
    printf("Array after shuffle :\n");
    print_array(array, array_size);

    // Perform a cyclic permutation
    perform_cyclic_permutation(array, array_size, cycle_number);
    printf("Array after cyclic permutation :\n");
    print_array(array, array_size);

    // Permute smallest value with the last value
    permute_lowest_value_with_last_value(array, array_size);
    printf("Array after swapping the smallest value with the last one :\n");
    print_array(array, array_size);

    // Descending sort the array by using the insertion algorithm
    sort_by_insertion_desc(array, array_size);
    printf("Array after insertion desc sort :\n");
    print_array(array, array_size);

    if (mode == USER_MODE) {
        // Ask the user a value and then return the total of elements that are smaller
        printf("Type a value : \n");
        scanf("%ld", &value);
    } else if (mode == COMPUTER_MODE) {
        value = rand() % MAX_RANDOM_VALUE + 1;
    }
    size_t elements_with_lower_value = count_elements_in_array_lower_than_value(array, array_size, value);
    printf("Number of elements with lower value : %ld\n", elements_with_lower_value);

    // Create a second array and compute it with the first one to a third array
    int *second_array = malloc(array_size * sizeof(int));
    int *result_sum_array = malloc(array_size * sizeof(int));
    fill_array_with_random_values(second_array, array_size);
    printf("Second array :\n");
    print_array(second_array, array_size);
    compute_two_array(array, second_array, result_sum_array, array_size);
    printf("Result array :\n");
    print_array(result_sum_array, array_size);

    // Create a fourth array that will stock the multiplication between the first array and a value from the user
    int *result_mul_array = malloc(array_size * sizeof(int));
    if (mode == USER_MODE) {
        printf("Multiply the first array with the following value : \n");
        scanf("%ld", &multiply_value);
    } else if (mode == COMPUTER_MODE) {
        multiply_value = rand() % MAX_RANDOM_VALUE + 1;
    }
    multiply_array_with_value(array, array_size, result_mul_array, multiply_value);
    printf("Result array after multiplication :\n");
    print_array(result_mul_array, array_size);

    // Convert the first array to an array of double
    double *converted_array = convert_int_array_to_double(array, array_size);
    printf("Array converted to double :\n");
    print_array_of_double(converted_array, array_size);

    // Free the memory
    free(array);
    free(second_array);
    free(result_sum_array);
    free(result_mul_array);
}

int main() {
    srand(time(NULL));
    printf("Starting user mode...\n");
    execute(USER_MODE);
    printf("Starting computer mode...\n");
    for (size_t i = 0; i < 100; i++) {
        execute(COMPUTER_MODE);
    }

    return 0;
}