/* Author : Dario GENGA
 * Date : 15.11.2021
 * Description : Manipulate an unidimensional array with dynamic memory allocation
 */

#include "unidimensional_array.h"
#include <stdio.h>

size_t ask_array_size() {
    size_t array_size = 0;
    printf("Size of the array : \n");
    scanf("%ld", &array_size);
    return array_size;
}

void shuffle_array(int *array, size_t array_size) {
    for (size_t i = 0; i < array_size; i++)
    {
        int index1 = rand() % (int)array_size;
        int index2 = rand() % (int)array_size;
        swap(&array[index1], &array[index2]);
    }
}

void fill_array_with_random_values(int *array, size_t array_size) {
    // Fill the array with all values from 0 to its size - 1
    for (size_t i = 0; i < array_size; i++)
    {
        array[i] = i;
    }

    // Then shuffle the array
    shuffle_array(array, array_size);
}


void perform_cyclic_permutation(int *array, size_t array_size, size_t cycle_number) {
    int *array_tmp = malloc(array_size * sizeof(int));

    for (size_t i = 0; i < array_size; i++) {
        size_t tmp_index = (i + cycle_number) % array_size;
        array_tmp[tmp_index] = array[i];
    }

    for (size_t i = 0; i < array_size; i++) {
        array[i] = array_tmp[i];
    }

    free(array_tmp);
}

void print_array(int* array, size_t array_size) {
    printf("[");
    for (size_t i = 0; i < array_size; i++)
    {
        printf("%d", array[i]);
        if (i + 1 < array_size) {
            printf(" , ");
        }
    }
    printf("]\n");
}

void print_array_of_double(double *array, size_t array_size) {
    printf("[");
    for (size_t i = 0; i < array_size; i++)
    {
        printf("%f", array[i]);
        if (i + 1 < array_size) {
            printf(" , ");
        }
    }
    printf("]\n");
}

int find_lowest_value_index_in_array(int *array, size_t array_size) {
    int lowest_value;
    size_t lowest_index;

    for (size_t i = 0; i < array_size; i++) {
        if (i == 0) {
            lowest_value = array[i];
            lowest_index = i;
        } else if (array[i] < lowest_value) {
            lowest_value = array[i];
            lowest_index = i;
        }
    }
    return lowest_index;
}

void permute_lowest_value_with_last_value(int *array, size_t array_size) {
    int lowest_index = (int)find_lowest_value_index_in_array(array, array_size);
    int last_index = array_size - 1;
    swap(&array[lowest_index], &array[last_index]);
}

void sort_by_insertion_desc(int *array, size_t array_size) {
    size_t i = 1;

    while (i < array_size) {
        size_t k = i;
        while (k > 0 && array[k - 1] < array[k]) {
            swap(&array[k], &array[k - 1]);
            k -= 1;
        }
        i++;
    }
}

size_t count_elements_in_array_lower_than_value(int *array, size_t array_size, int value) {
    size_t total = 0;

    for (size_t i = 0; i < array_size; i++)
    {
        if (array[i] < value) {
            total++;
        }
    }

    return total;
}

void compute_two_array(int *first_array, int *second_array, int *result_array, size_t array_size) {
    for (size_t i = 0; i < array_size; i++) {
        result_array[i] = first_array[i] + second_array[i];
    }
}

void multiply_array_with_value(int *array, size_t array_size, int *result_array, int value) {
    for (size_t i = 0; i < array_size; i++) {
        result_array[i] = array[i] * value;
    }
}

double *convert_int_array_to_double(int* array, size_t array_size) {
    double *converted_array = malloc(array_size * sizeof(double));

    for (size_t i = 0; i < array_size; i++) {
        converted_array[i] = (double)array[i];
    }

    return converted_array;
}

void swap(int *x, int *y)
{
    int tmp = *x;
    *x = *y;
    *y = tmp;
}
