/* Author : Dario GENGA
 * Date : 15.11.2021
 * Description : Manipulate an unidimensional array with dynamic memory allocation
 */
#ifndef _UNIDIMENSIONAL_ARRAY_H
#define _UNIDIMENSIONAL_ARRAY_H
#include <stdio.h>
#include <stdlib.h>

size_t ask_array_size();

void fill_array_with_random_values(int *array, size_t array_size);

int find_lowest_value_index_in_array(int *array, size_t array_size);

void permute_lowest_value_with_last_value(int *array, size_t array_size);

void shuffle_array(int *array, size_t array_size);

void perform_cyclic_permutation(int *array, size_t array_size, size_t cycle_number);

void sort_by_insertion_desc(int *array, size_t array_size);

size_t count_elements_in_array_lower_than_value(int *array, size_t array_size, int value);

void compute_two_array(int *first_array, int *second_array, int *result_array,  size_t array_size);

void multiply_array_with_value(int *array, size_t array_size, int *result_array, int value);

double *convert_int_array_to_double(int *array, size_t array_size);

void print_array(int *array, size_t array_size);

void print_array_of_double(double *array, size_t array_size);

void swap(int *x, int *y);

#endif