import * as ExpressValidator from 'express-validator';
import express               from 'express';
import { StatusCodes }       from 'http-status-codes';


class ParamsValidatorMiddleware {
    validate(validations: Array<ExpressValidator.ValidationChain> | ExpressValidator.Schema): (req: express.Request, res: express.Response, next: express.NextFunction) => void {
        return (req: express.Request, res: express.Response, next: express.NextFunction) => {
            if ( !(validations instanceof Array) ) {
                validations = ExpressValidator.checkSchema(validations);
            }

            Promise.all(validations.map(validation => validation.run(req))).then(() => {
                const errors = ExpressValidator.validationResult(req);
                if ( !errors.isEmpty() ) {
                    req.session.sendResponse(res, StatusCodes.BAD_REQUEST, { errors: errors.array() });
                    return;
                }

                next();
            });
        };
    }
}


export default new ParamsValidatorMiddleware();
