import { Express }      from 'express-serve-static-core';
import RoutesManager    from '../express/RoutesManager';
import BaseRoutes       from './BaseRoutes';
import SessionRoutes    from './SessionRoutes';
import AssignmentRoutes from './AssignmentRoutes';
import GitlabRoutes     from './GitlabRoutes';
import ExerciseRoutes   from './ExerciseRoutes';


class AdminRoutesManager implements RoutesManager {
    registerOnBackend(backend: Express) {
        BaseRoutes.registerOnBackend(backend);
        SessionRoutes.registerOnBackend(backend);
        GitlabRoutes.registerOnBackend(backend);
        AssignmentRoutes.registerOnBackend(backend);
        ExerciseRoutes.registerOnBackend(backend);
    }
}


export default new AdminRoutesManager();
