import { PrismaClient }    from '@prisma/client';
import logger              from '../shared/logging/WinstonLogger';
import UserQueryExtension  from './Prisma/Extensions/UserQueryExtension';
import UserResultExtension from './Prisma/Extensions/UserResultExtension';


const prisma = new PrismaClient({
                                    log: [ {
                                        emit : 'event',
                                        level: 'query'
                                    }, {
                                        emit : 'event',
                                        level: 'info'
                                    }, {
                                        emit : 'event',
                                        level: 'warn'
                                    }, {
                                        emit : 'event',
                                        level: 'error'
                                    } ]
                                });

prisma.$on('query', e => {
    logger.debug(`Prisma => Query (${ e.duration }ms): ${ e.query }`);
    logger.debug(`Prisma => Params: ${ e.params }\n`);
});
prisma.$on('info', e => logger.info(`Prisma => ${ e.message }`));
prisma.$on('warn', e => logger.warn(`Prisma => ${ e.message }`));
prisma.$on('error', e => logger.error(`Prisma => ${ e.message }`));


const db = prisma.$extends(UserQueryExtension).$extends(UserResultExtension);


export default db;