import { Prisma }       from '@prisma/client';
import { Enonce, User } from '../types/DatabaseTypes';
import db               from '../helpers/DatabaseHelper';


class EnonceManager {
    async isUserAllowedToAccessEnonce(enonce: Enonce, user: User): Promise<boolean> {
        if ( !enonce.staff ) {
            enonce.staff = await db.enonce.findUnique({
                                                          where: {
                                                              name: enonce.name
                                                          }
                                                      }).staff() ?? [];
        }
        return enonce.staff.findIndex(staff => staff.id === user.id) !== -1;
    }

    async getByName(name: string, include: Prisma.EnonceInclude | undefined = undefined): Promise<Enonce | undefined> {
        return await db.enonce.findUnique({
                                              where  : {
                                                  name: name
                                              },
                                              include: include
                                          }) as unknown as Enonce ?? undefined;
    }

    getByGitlabLink(gitlabLink: string, include: Prisma.EnonceInclude | undefined = undefined): Promise<Enonce | undefined> {
        const name = gitlabLink.replace('.git', '').split('/').pop()!;

        return this.getByName(name, include);
    }

    get(nameOrUrl: string, include: Prisma.EnonceInclude | undefined = undefined): Promise<Enonce | undefined> {
        // We can use the same function for both name and url because the name is the last part of the url and the name extraction from the url doesn't corrupt the name
        return this.getByGitlabLink(nameOrUrl, include);
    }
}


export default new EnonceManager();
