import { Prisma }   from '@prisma/client';
import { Exercice } from '../types/DatabaseTypes';
import db           from '../helpers/DatabaseHelper';


class ExerciceManager {
    async get(id: string, include: Prisma.ExerciceInclude | undefined = undefined): Promise<Exercice | undefined> {
        return await db.exercice.findUnique({
                                                where  : {
                                                    id: id
                                                },
                                                include: include
                                            }) as unknown as Exercice ?? undefined;
    }
}


export default new ExerciceManager();
