import { Express }     from 'express-serve-static-core';
import express         from 'express';
import { StatusCodes } from 'http-status-codes';
import EnonceManager   from '../managers/EnonceManager';
import ExerciceManager from '../managers/ExerciceManager';


type GetFunction = (id: string | number, ...args: Array<any>) => Promise<any>


class ParamsCallbackManager {
    protected listenParam(paramName: string, backend: Express, getFunction: GetFunction, args: Array<any>, indexName: string) {
        backend.param(paramName, (req: express.Request, res: express.Response, next: express.NextFunction, id: string | number) => {
            getFunction(id, ...args).then(result => {
                if ( result ) {
                    this.initBoundParams(req);
                    (req.boundParams as any)[indexName] = result;

                    next();
                } else {
                    req.session.sendResponse(res, StatusCodes.NOT_FOUND, {}, 'Param bounding failed: ' + paramName);
                }
            });
        });
    }

    initBoundParams(req: express.Request) {
        if ( !req.boundParams ) {
            req.boundParams = {
                enonce  : undefined,
                exercice: undefined
            };
        }
    }

    register(backend: Express) {
        this.listenParam('enonceNameOrUrl', backend, (EnonceManager.get as GetFunction).bind(EnonceManager), [ {
            exercices: true,
            staff    : true
        } ], 'enonce');

        this.listenParam('exerciceId', backend, (ExerciceManager.get as GetFunction).bind(ExerciceManager), [ {
            enonce : true,
            members: true,
            results: true
        } ], 'exercice');
    }
}


export default new ParamsCallbackManager();
