import { Prisma } from '@prisma/client';
import LazyVal    from '../shared/helpers/LazyVal';
import GitlabUser from '../shared/types/Gitlab/GitlabUser';


const userBase = Prisma.validator<Prisma.UserArgs>()({
                                                         include: { exercices: true }
                                                     });
const enonceBase = Prisma.validator<Prisma.EnonceArgs>()({
                                                             include: {
                                                                 exercices: true,
                                                                 staff    : true
                                                             }
                                                         });
const exerciceBase = Prisma.validator<Prisma.ExerciceArgs>()({
                                                                 include: {
                                                                     enonce : true,
                                                                     members: true,
                                                                     results: true
                                                                 }
                                                             });
const resultBase = Prisma.validator<Prisma.ResultArgs>()({
                                                             include: {
                                                                 exercice: true
                                                             }
                                                         });


export type User = Omit<Prisma.UserGetPayload<typeof userBase>, 'password'> & {
    password?: string
    isTeachingStaff: boolean
    gitlabProfile: LazyVal<GitlabUser>
}
export type Enonce = Prisma.EnonceGetPayload<typeof enonceBase>
export type Exercice = Prisma.ExerciceGetPayload<typeof exerciceBase>
export type Result = Prisma.ResultGetPayload<typeof resultBase>