// ATTENTION : This line MUST be the first of this file
import './init.js';

import SharedConfig   from './shared/config/SharedConfig.js';
import WorkerRole     from './process/WorkerRole.js';
import ClusterManager from './process/ClusterManager.js';
import API            from './express/API.js';
import HttpManager    from './managers/HttpManager.js';


HttpManager.registerAxiosInterceptor();


if ( SharedConfig.production ) {
    (new ClusterManager([ {
        role         : WorkerRole.API,
        quantity     : ClusterManager.CORES,
        restartOnFail: true,
        loadTask     : () => new API()
    } ])).run();
} else {
    (new API()).run();
}
