import { Prisma }  from '@prisma/client';
import LazyVal     from '../shared/helpers/LazyVal.js';
import * as Gitlab from '@gitbeaker/rest';


const userBase = Prisma.validator<Prisma.UserDefaultArgs>()({
                                                                include: { exercises: true }
                                                            });
const assignmentBase = Prisma.validator<Prisma.AssignmentDefaultArgs>()({
                                                                            include: {
                                                                                exercises: true,
                                                                                staff    : true,
                                                                                tags     : true
                                                                            }
                                                                        });
const exerciseBase = Prisma.validator<Prisma.ExerciseDefaultArgs>()({
                                                                        include: {
                                                                            assignment: true,
                                                                            members   : true,
                                                                            results   : true,
                                                                            tags      : true
                                                                        }
                                                                    });
const resultBase = Prisma.validator<Prisma.ResultDefaultArgs>()({
                                                                    include: {
                                                                        exercise: true
                                                                    }
                                                                });
const tagBase = Prisma.validator<Prisma.TagDefaultArgs>()({
                                                              include: {
                                                                  exercises  : true,
                                                                  assignments: true
                                                              }
                                                          });


export type User = Prisma.UserGetPayload<typeof userBase> & {
    isTeachingStaff: boolean
    isAdmin: boolean
    gitlabProfile: LazyVal<Gitlab.UserSchema>
}
export type Exercise = Prisma.ExerciseGetPayload<typeof exerciseBase> & {
    isCorrection: boolean
}
export type Assignment = Prisma.AssignmentGetPayload<typeof assignmentBase> & {
    corrections: LazyVal<Array<Exercise>>
}
export type Result = Prisma.ResultGetPayload<typeof resultBase>
export type Tag = Prisma.TagGetPayload<typeof tagBase>