import { Express }        from 'express-serve-static-core';
import express            from 'express';
import RoutesManager      from '../express/RoutesManager';
import SecurityMiddleware from '../middlewares/SecurityMiddleware';
import SecurityCheckType  from '../types/SecurityCheckType';
import GitlabManager      from '../managers/GitlabManager';


class GitlabRoutes implements RoutesManager {
    registerOnBackend(backend: Express) {
        backend.get('/gitlab/project/:gitlabProjectIdOrNamespace/checkTemplateAccess', SecurityMiddleware.check(true, SecurityCheckType.TEACHING_STAFF), this.checkTemplateAccess.bind(this));
    }

    private async checkTemplateAccess(req: express.Request, res: express.Response) {
        const gitlabProjectIdOrNamespace: string = req.params.gitlabProjectIdOrNamespace;

        await GitlabManager.checkTemplateAccess(gitlabProjectIdOrNamespace, req, res);
    }
}


export default new GitlabRoutes();
