import { Prisma } from '@prisma/client';


export default Prisma.defineExtension(client => {
    return client.$extends({
                               result: {
                                   exercise: {
                                       isCorrection: {
                                           needs: {
                                               correctionCommit: true
                                           },
                                           compute(exercise) {
                                               return exercise.correctionCommit != null;
                                           }
                                       }
                                   }
                               }
                           });
});