import { Prisma, Tag }           from '@prisma/client';
import db                   from '../helpers/DatabaseHelper';

class TagManager {
	async get(name: string, include: Prisma.TagInclude | undefined = undefined): Promise<Tag | undefined> {
        return await db.tag.findUnique({
                                                where  : {
                                                    name: name
                                                },
                                                include: include
                                            }) as unknown as Tag ?? undefined;
    }
}

export default new TagManager();

