import express     from 'express';
import Session     from '../controllers/Session';
import { Express } from 'express-serve-static-core';


class SessionMiddleware {
    registerOnBackend(backend: Express) {
        backend.use(async (req: express.Request, res: express.Response, next: express.NextFunction) => {
            req.session = new Session();
            await req.session.initSession(req, res);

            return next();
        });
    }
}


export default new SessionMiddleware();
