import { PrismaClient }          from '@prisma/client';
import logger                    from '../shared/logging/WinstonLogger.js';
import UserQueryExtension        from './Prisma/Extensions/UserQueryExtension.js';
import UserResultExtension       from './Prisma/Extensions/UserResultExtension.js';
import AssignmentResultExtension from './Prisma/Extensions/AssignmentResultExtension.js';
import ExerciseResultExtension   from './Prisma/Extensions/ExerciseResultExtension.js';


const prisma = new PrismaClient({
                                    log: [ {
                                        emit : 'event',
                                        level: 'query'
                                    }, {
                                        emit : 'event',
                                        level: 'info'
                                    }, {
                                        emit : 'event',
                                        level: 'warn'
                                    }, {
                                        emit : 'event',
                                        level: 'error'
                                    } ]
                                });

prisma.$on('query', e => {
    logger.debug(`Prisma => Query (${ e.duration }ms): ${ e.query }`);
    logger.debug(`Prisma => Params: ${ e.params }\n`);
});
prisma.$on('info', e => logger.info(`Prisma => ${ e.message }`));
prisma.$on('warn', e => logger.warn(`Prisma => ${ e.message }`));
prisma.$on('error', e => logger.error(`Prisma => ${ e.message }`));


const DatabaseHelper = prisma.$extends(UserQueryExtension).$extends(UserResultExtension).$extends(AssignmentResultExtension).$extends(ExerciseResultExtension);


export default DatabaseHelper;