import { Prisma }   from '@prisma/client';
import { Exercise } from '../../../types/DatabaseTypes.js';
import db           from '../../DatabaseHelper.js';
import LazyVal      from '../../../shared/helpers/LazyVal.js';


async function getCorrections(assignment: { name: string }): Promise<Array<Partial<Exercise>> | undefined> {
    try {
        return await db.exercise.findMany({
                                              where  : {
                                                  assignmentName  : assignment.name,
                                                  correctionCommit: {
                                                      not: Prisma.JsonNull
                                                  }
                                              },
                                              include: {
                                                  assignment: false,
                                                  members   : true,
                                                  results   : false
                                              }
                                          }) as Array<Partial<Exercise>> ?? undefined;
    } catch ( e ) {
        return undefined;
    }
}

export default Prisma.defineExtension(client => {
    return client.$extends({
                               result: {
                                   assignment: {
                                       corrections: {
                                           compute(assignment) {
                                               return new LazyVal<Array<Partial<Exercise>> | undefined>(() => assignment.published ? getCorrections(assignment) : []);
                                           }
                                       }
                                   }
                               }
                           });
});