import { Prisma } from '@prisma/client';


export default Prisma.defineExtension(client => {
    return client.$extends({
                               query: {
                                   user: {
                                       async delete({
                                                        args
                                                    }) {

                                           return client.user.update(Object.assign(args, {
                                               data: {
                                                   deleted: true
                                               }
                                           }));
                                       },
                                       async deleteMany({
                                                            args
                                                        }) {

                                           return client.user.updateMany(Object.assign(args, {
                                               data: {
                                                   deleted: true
                                               }
                                           }));
                                       }
                                   }
                               }
                           });
});