import { Prisma, UserRole } from '@prisma/client';
import LazyVal              from '../../../shared/helpers/LazyVal.js';
import * as Gitlab          from '@gitbeaker/rest';
import GitlabManager        from '../../../managers/GitlabManager.js';


export default Prisma.defineExtension(client => {
    return client.$extends({
                               result: {
                                   user: {
                                       isTeachingStaff: {
                                           needs: {
                                               role: true
                                           },
                                           compute(user) {
                                               return user.role === UserRole.TEACHING_STAFF || user.role === UserRole.ADMIN;
                                           }
                                       },
                                       isAdmin        : {
                                           needs: {
                                               role: true
                                           },
                                           compute(user) {
                                               return user.role === UserRole.ADMIN;
                                           }
                                       },
                                       gitlabProfile  : {
                                           compute(user) {
                                               return new LazyVal<Gitlab.UserSchema | undefined>(() => GitlabManager.getUserById(user.id));
                                           }
                                       }
                                   }
                               }
                           });
});