import path         from 'node:path';
import cluster      from 'node:cluster';
import dotenv       from 'dotenv';
import dotenvExpand from 'dotenv-expand';
import './shared/helpers/TypeScriptExtensions.js';


if ( cluster.isPrimary ) {
    if ( process.env.NODE_ENV && process.env.NODE_ENV === 'production' ) {
        dotenvExpand.expand(dotenv.config());
    } else {
        dotenv.config({ path: path.join(__dirname, '../.env.keys') });
        dotenvExpand.expand(dotenv.config({ DOTENV_KEY: process.env.DOTENV_KEY_DEVELOPMENT }));
    }
}
