import { Prisma }         from '@prisma/client';
import { Exercise, User } from '../types/DatabaseTypes.js';
import db                 from '../helpers/DatabaseHelper.js';


class ExerciseManager {
    async get(idOrUrl: string, include: Prisma.ExerciseInclude | undefined = undefined): Promise<Exercise | undefined> {
        const id = idOrUrl.replace('.git', '').split('_').pop()!;

        return await db.exercise.findUnique({
                                                where  : {
                                                    id: id
                                                },
                                                include: include
                                            }) as unknown as Exercise ?? undefined;
    }

    getFromAssignment(assignmentName: string, include: Prisma.ExerciseInclude | undefined = undefined): Promise<Array<Exercise>> {
        return db.exercise.findMany({
                                        where  : {
                                            assignmentName: assignmentName
                                        },
                                        include: include
                                    }) as Promise<Array<Exercise>>;
    }

    async isUserAllowedToAccessExercise(exercise: Exercise, user: User): Promise<boolean> {
        if ( !exercise.members ) {
            exercise.members = await db.exercise.findUnique({
                                                                where: {
                                                                    id: exercise.id
                                                                }
                                                            }).members() ?? [];
        }

        const assignmentStaff = (await db.assignment.findUnique({
                                                                    where: {
                                                                        name: exercise.assignmentName
                                                                    }
                                                                }).staff()) ?? [];

        return exercise.members.findIndex(member => member.id === user.id) !== -1 || assignmentStaff.findIndex(staff => staff.id === user.id) !== -1;
    }
}


export default new ExerciseManager();
