import { Prisma }   from '@prisma/client';
import { Exercise } from '../types/DatabaseTypes.js';
import db           from '../helpers/DatabaseHelper.js';


class ExerciseManager {
    async get(idOrUrl: string, include: Prisma.ExerciseInclude | undefined = undefined): Promise<Exercise | undefined> {
        const id = idOrUrl.replace('.git', '').split('_').pop()!;

        return await db.exercise.findUnique({
                                                where  : {
                                                    id: id
                                                },
                                                include: include
                                            }) as unknown as Exercise ?? undefined;
    }

    getFromAssignment(assignmentName: string, include: Prisma.ExerciseInclude | undefined = undefined): Promise<Array<Exercise>> {
        return db.exercise.findMany({
                                        where  : {
                                            assignmentName: assignmentName
                                        },
                                        include: include
                                    }) as Promise<Array<Exercise>>;
    }
}


export default new ExerciseManager();
