import { Prisma }           from '@prisma/client';
import { Assignment, User } from '../types/DatabaseTypes';
import db                   from '../helpers/DatabaseHelper';

enum TagType{
	Language,
	Framework,
	Theme,
	UserDefined
}

class TagsManager {
    async isUserAllowedToAccessTag(tag: Tags, user: User): Promise<boolean> {
        if ( !tag.staff ) {
            tag.staff = await db.assignment.findUnique({
                                                                  where: {
                                                                      name: tag.name
                                                                  }
                                                              }).staff() ?? [];
        }
        return tag.staff.findIndex(staff => staff.id === user.id) !== -1;
    }

    async getByName(name: string, include: Prisma.TagInclude | undefined = undefined): Promise<Tag | undefined> {
        return await db.assignment.findUnique({
                                                  where     : {
                                                      name: name
                                                  }, include: include
                                              }) as unknown as Tag ?? undefined;
    }

    getByGitlabLink(gitlabLink: string, include: Prisma.AssignmentInclude | undefined = undefined): Promise<Assignment | undefined> {
        const name = gitlabLink.replace('.git', '').split('/').pop()!;

        return this.getByName(name, include);
    }

    get(nameOrUrl: string, include: Prisma.AssignmentInclude | undefined = undefined): Promise<Assignment | undefined> {
        // We can use the same function for both name and url because the name is the last part of the url and the name extraction from the url doesn't corrupt the name
        return this.getByGitlabLink(nameOrUrl, include);
    }
}


export default new TagManager();
