require('dotenv').config(); // ATTENTION : This line MUST be the first of this file
require('./shared/helpers/TypeScriptExtensions'); // ATTENTION : This line MUST be the second of this file

import WorkerRole     from './process/WorkerRole';
import ClusterManager from './process/ClusterManager';
import API            from './express/API';
import HttpManager    from './managers/HttpManager';


HttpManager.registerAxiosInterceptor();


(new ClusterManager([ {
    role         : WorkerRole.API,
    quantity     : ClusterManager.CORES,
    restartOnFail: true,
    loadTask     : () => {
        return new API();
    }
} ])).run();
