import { Prisma } from '@prisma/client';
import { Enonce } from '../types/DatabaseTypes';
import db         from '../helpers/DatabaseHelper';


class EnonceManager {
    private static _instance: EnonceManager;

    private constructor() { }

    public static get instance(): EnonceManager {
        if ( !EnonceManager._instance ) {
            EnonceManager._instance = new EnonceManager();
        }

        return EnonceManager._instance;
    }

    async getByName(name: string, include: Prisma.EnonceInclude | undefined = undefined): Promise<Enonce | undefined> {
        return db.enonce.findUnique({
                                        where  : {
                                            name: name
                                        },
                                        include: include
                                    });
    }

    getByGitlabLink(gitlabLink: string, include: Prisma.EnonceInclude | undefined = undefined): Promise<Enonce | undefined> {
        const name = gitlabLink.replace('.git', '').split('/').pop();

        return this.getByName(name, include);
    }

    get(nameOrUrl: string, include: Prisma.EnonceInclude | undefined = undefined): Promise<Enonce | undefined> {
        // We can use the same function for both name and url because the name is the last part of the url and the name extraction from the url doesn't corrupt the name
        return this.getByGitlabLink(nameOrUrl, include);
    }
}


export default EnonceManager.instance;
