import axios, { AxiosError, AxiosRequestHeaders } from 'axios';
import Config                                     from '../config/Config';
import FormData                                   from 'form-data';
import logger                                     from '../shared/logging/WinstonLogger';


class HttpManager {
    registerAxiosInterceptor() {
        this.registerRequestInterceptor();
        this.registerResponseInterceptor();
    }

    private registerRequestInterceptor() {
        axios.interceptors.request.use((config) => {
            if ( config.data instanceof FormData ) {
                config.headers = { ...config.headers, ...(config.data as FormData).getHeaders() } as AxiosRequestHeaders;
            }

            if ( config.url && config.url.indexOf(Config.gitlab.apiURL) !== -1 ) {
                config.headers['PRIVATE-TOKEN'] = Config.gitlab.account.token;
            }

            return config;
        });
    }

    private registerResponseInterceptor() {
        axios.interceptors.response.use((response) => {
            return response;
        }, (error) => {
            if ( error instanceof AxiosError ) {
                logger.error(`${ JSON.stringify(error.response.data) }`);
            } else {
                logger.error(`${ JSON.stringify(error) }`);
            }

            return Promise.reject(error);
        });
    }
}


export default new HttpManager();

