import { Express }     from 'express-serve-static-core';
import ApiRequest      from '../types/ApiRequest';
import express         from 'express';
import { StatusCodes } from 'http-status-codes';
import EnonceManager   from '../managers/EnonceManager';


class ParamsCallbackManager {
    protected listenParam(paramName: string, backend: Express, getFunction: (id: string | number, ...args: Array<any>) => Promise<any>, args: Array<any>, indexName: string) {
        backend.param(paramName, (req: ApiRequest, res: express.Response, next: express.NextFunction, id: string | number) => {
            getFunction(id, ...args).then(result => {
                if ( result ) {
                    this.initBoundParams(req);
                    (req.boundParams as any)[indexName] = result;

                    next();
                } else {
                    req.session.sendResponse(res, StatusCodes.NOT_FOUND, {}, 'Param bounding failed: ' + paramName);
                }
            });
        });
    }

    initBoundParams(req: ApiRequest) {
        if ( !req.boundParams ) {
            req.boundParams = {
                enonce: null
            };
        }
    }

    register(backend: Express) {
        this.listenParam('enonceNameOrUrl', backend, EnonceManager.get.bind(EnonceManager), [ {
            exercices: true,
            staff    : true
        } ], 'enonce');
    }
}


export default new ParamsCallbackManager();
