import express    from 'express';
import ApiRequest from '../types/ApiRequest';
import Session    from '../controllers/Session';


class SessionMiddleware {
    register(): (req: ApiRequest, res: express.Response, next: express.NextFunction) => void {
        return async (req: ApiRequest, res: express.Response, next: express.NextFunction) => {
            req.session = new Session();
            await req.session.initSession(req);

            return next();
        };
    }
}


export default new SessionMiddleware();
