import axios, { AxiosError, AxiosRequestHeaders } from 'axios';
import FormData                                   from 'form-data';
import logger                                     from '../shared/logging/WinstonLogger.js';


class HttpManager {
    registerAxiosInterceptor() {
        this.registerRequestInterceptor();
        this.registerResponseInterceptor();
    }

    private registerRequestInterceptor() {
        axios.interceptors.request.use(config => {
            if ( config.data instanceof FormData ) {
                config.headers = { ...config.headers, ...config.data.getHeaders() } as AxiosRequestHeaders;
            }
            return config;
        });
    }

    private registerResponseInterceptor() {
        axios.interceptors.response.use(response => response, error => {
            if ( error instanceof AxiosError ) {
                logger.error(`${ JSON.stringify(error.response?.data) }`);
            } else {
                logger.error(`${ JSON.stringify(error) }`);
            }

            return Promise.reject(error);
        });
    }
}


export default new HttpManager();

