import { TagProposal } from '@prisma/client';
import db              from '../helpers/DatabaseHelper';


class TagProposalManager {
    async get(name: string | undefined = undefined): Promise<TagProposal | undefined> {
        return await db.tagProposal.findUnique({
                                                   where: {
                                                       name: name
                                                   }
                                               }) as unknown as TagProposal ?? undefined;
    }
}


export default new TagProposalManager();

