import { Express }      from 'express-serve-static-core';
import RoutesManager    from '../express/RoutesManager.js';
import BaseRoutes       from './BaseRoutes.js';
import SessionRoutes    from './SessionRoutes.js';
import AssignmentRoutes from './AssignmentRoutes.js';
import GitlabRoutes     from './GitlabRoutes.js';
import ExerciseRoutes   from './ExerciseRoutes.js';
import TagsRoutes       from './TagRoutes';
import UserRoutes       from './UserRoutes';


class AdminRoutesManager implements RoutesManager {
    registerOnBackend(backend: Express) {
        BaseRoutes.registerOnBackend(backend);
        SessionRoutes.registerOnBackend(backend);
        GitlabRoutes.registerOnBackend(backend);
        AssignmentRoutes.registerOnBackend(backend);
        ExerciseRoutes.registerOnBackend(backend);
        TagsRoutes.registerOnBackend(backend);
        UserRoutes.registerOnBackend(backend);
    }
}


export default new AdminRoutesManager();
