import { Express }                 from 'express-serve-static-core';
import express, { RequestHandler } from 'express';
import { StatusCodes }             from 'http-status-codes';
import RoutesManager               from '../express/RoutesManager.js';
import Config                      from '../config/Config';
import SharedConfig    from '../shared/config/SharedConfig';
import GlobalHelper    from '../helpers/GlobalHelper';


class BaseRoutes implements RoutesManager {
    registerOnBackend(backend: Express) {
        backend.get('/', this.homepage.bind(this) as RequestHandler);
        backend.get('/health_check', this.healthCheck.bind(this) as RequestHandler);

        backend.get('/sonar', this.sonar.bind(this));
        
        backend.get('/clients_config', this.clientsConfig.bind(this) as RequestHandler);
    }

    private async homepage(req: express.Request, res: express.Response) {
        return req.session.sendResponse(res, StatusCodes.OK);
    }

    private async healthCheck(req: express.Request, res: express.Response) {
        return req.session.sendResponse(res, StatusCodes.OK);
    }

    private async clientsConfig(req: express.Request, res: express.Response) {
        return req.session.sendResponse(res, StatusCodes.OK, {
            gitlabUrl               : Config.gitlab.url,
            gitlabAccountId         : Config.gitlab.account.id,
            gitlabAccountUsername   : Config.gitlab.account.username,
            loginGitlabClientId     : Config.login.gitlab.client.id,
            exerciseMaxPerAssignment: Config.exercise.maxPerAssignment
        });
    }

    private async sonar(req: express.Request, res: express.Response) {
        const data = {
            sonarEnabled: await GlobalHelper.isSonarSupported()
        };
        return req.session.sendResponse(res, StatusCodes.OK, data);
    }
}


export default new BaseRoutes();
