-- CreateTable
CREATE TABLE `User` (
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `firstname` VARCHAR(191) NOT NULL,
    `lastname` VARCHAR(191) NULL,
    `mail` VARCHAR(191) NULL,
    `password` VARCHAR(191) NULL,
    `gitlabId` INTEGER NOT NULL,
    `role` VARCHAR(191) NULL,
    `deleted` BOOLEAN NOT NULL DEFAULT false,

    UNIQUE INDEX `User_mail_key`(`mail`),
    UNIQUE INDEX `User_gitlabId_key`(`gitlabId`),
    PRIMARY KEY (`id`)
) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- CreateTable
CREATE TABLE `Enonce` (
    `name` VARCHAR(191) NOT NULL,
    `gitlabId` INTEGER NOT NULL,
    `gitlabLink` VARCHAR(191) NOT NULL,
    `gitlabCreationInfo` JSON NOT NULL,
    `gitlabLastInfo` JSON NOT NULL,
    `gitlabLastInfoDate` DATETIME(3) NOT NULL,

    PRIMARY KEY (`name`)
) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- CreateTable
CREATE TABLE `Exercice` (
    `id` CHAR(36) NOT NULL,
    `enonceName` VARCHAR(191) NOT NULL,
    `name` VARCHAR(191) NOT NULL,
    `gitlabId` INTEGER NOT NULL,
    `gitlabLink` VARCHAR(191) NOT NULL,
    `gitlabCreationInfo` JSON NOT NULL,
    `gitlabLastInfo` JSON NOT NULL,
    `gitlabLastInfoDate` DATETIME(3) NOT NULL,

    PRIMARY KEY (`id`)
) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- CreateTable
CREATE TABLE `Result` (
    `exerciceId` CHAR(36) NOT NULL,
    `dateTime` DATETIME(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
    `pass` BOOLEAN NOT NULL,
    `details` TEXT NOT NULL,

    PRIMARY KEY (`exerciceId`, `dateTime`)
) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- CreateTable
CREATE TABLE `_EnonceToUser` (
    `A` VARCHAR(191) NOT NULL,
    `B` INTEGER NOT NULL,

    UNIQUE INDEX `_EnonceToUser_AB_unique`(`A`, `B`),
    INDEX `_EnonceToUser_B_index`(`B`)
) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- CreateTable
CREATE TABLE `_ExerciceToUser` (
    `A` CHAR(36) NOT NULL,
    `B` INTEGER NOT NULL,

    UNIQUE INDEX `_ExerciceToUser_AB_unique`(`A`, `B`),
    INDEX `_ExerciceToUser_B_index`(`B`)
) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- AddForeignKey
ALTER TABLE `Exercice` ADD CONSTRAINT `Exercice_enonceName_fkey` FOREIGN KEY (`enonceName`) REFERENCES `Enonce`(`name`) ON DELETE NO ACTION ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE `Result` ADD CONSTRAINT `Result_exerciceId_fkey` FOREIGN KEY (`exerciceId`) REFERENCES `Exercice`(`id`) ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE `_EnonceToUser` ADD CONSTRAINT `_EnonceToUser_A_fkey` FOREIGN KEY (`A`) REFERENCES `Enonce`(`name`) ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE `_EnonceToUser` ADD CONSTRAINT `_EnonceToUser_B_fkey` FOREIGN KEY (`B`) REFERENCES `User`(`id`) ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE `_ExerciceToUser` ADD CONSTRAINT `_ExerciceToUser_A_fkey` FOREIGN KEY (`A`) REFERENCES `Exercice`(`id`) ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE `_ExerciceToUser` ADD CONSTRAINT `_ExerciceToUser_B_fkey` FOREIGN KEY (`B`) REFERENCES `User`(`id`) ON DELETE CASCADE ON UPDATE CASCADE;
