require('dotenv').config(); // ATTENTION : This line MUST be the first of this file
require('../src/shared/helpers/TypeScriptExtensions'); // ATTENTION : This line MUST be the second of this file

import Config      from '../src/config/Config';
import logger      from '../src/shared/logging/WinstonLogger';
import * as bcrypt from 'bcryptjs';
import db          from '../src/helpers/DatabaseHelper';


async function main() {
    await db.user.upsert({
                             where : { gitlabId: 142 },
                             update: {},
                             create: {
                                 id       : 1,
                                 firstname: 'Michaël',
                                 lastname : 'Minelli',
                                 mail     : 'michael@minelli.me',
                                 password : bcrypt.hashSync('123456', Config.userPasswordSaltRounds),
                                 gitlabId : 142,
                                 role     : 'colsci',
                                 deleted  : false
                             }
                         });
}

main().then(async () => {
    await db.$disconnect();
}).catch(async (e) => {
    logger.error(e);
    await db.$disconnect();
    process.exit(1);
});