import GitlabVisibility from '../shared/types/Gitlab/GitlabVisibility';


class Config {
    public readonly api: {
        port: number
    };

    public jwtConfig: {
        secret: string; expiresIn: number;
    };

    public permissions: {
        teachingStaff: Array<string>;
    };

    public gitlab: {
        apiURL: string; urls: Array<string>; account: { id: number; username: string; token: string; }; group: { root: number; templates: number; enonces: number; exercices: number; };
    };

    public enonce: {
        default: { description: string; initReadme: boolean; sharedRunnersEnabled: boolean; visibility: string; wikiEnabled: boolean; template: string }; baseFiles: Array<string>; filename: string
    };

    public exercice: {
        maxSameName: number; resultsFolder: string; default: { description: string; visibility: string; };
    };

    public readonly userPasswordLength: number;
    public readonly userPasswordSaltRounds: number;

    constructor() {
        this.api = {
            port: Number(process.env.API_PORT || 30992)
        };

        this.jwtConfig = {
            secret   : process.env.JWT_SECRET_KEY || '',
            expiresIn: Number(process.env.SESSION_TIMEOUT || 0)
        };

        this.permissions = {
            teachingStaff: JSON.parse(process.env.ROLES_WITH_TEACHING_STAFF_PERMISSIONS || '[]')
        };

        this.gitlab = {
            apiURL : process.env.GITLAB_API_URL || '',
            urls   : JSON.parse(process.env.GITLAB_URLS || '[]'),
            account: {
                id      : Number(process.env.GITLAB_DOJO_ACCOUNT_ID || 0),
                username: process.env.GITLAB_DOJO_ACCOUNT_USERNAME || '',
                token   : process.env.GITLAB_DOJO_ACCOUNT_TOKEN || ''
            },
            group  : {
                root     : Number(process.env.GITLAB_GROUP_ROOT_ID || 0),
                templates: Number(process.env.GITLAB_GROUP_TEMPLATES_ID || 0),
                enonces  : Number(process.env.GITLAB_GROUP_ENONCES_ID || 0),
                exercices: Number(process.env.GITLAB_GROUP_EXERCICES_ID || 0)
            }
        };

        this.enonce = {
            default  : {
                description         : process.env.ENONCE_DEFAULT_DESCRIPTION?.convertWithEnvVars() ?? '',
                initReadme          : process.env.ENONCE_DEFAULT_INIT_README?.toBoolean() ?? false,
                sharedRunnersEnabled: process.env.ENONCE_DEFAULT_SHARED_RUNNERS_ENABLED?.toBoolean() ?? true,
                visibility          : process.env.ENONCE_DEFAULT_VISIBILITY || GitlabVisibility.PRIVATE,
                wikiEnabled         : process.env.ENONCE_DEFAULT_WIKI_ENABLED?.toBoolean() ?? false,
                template            : process.env.ENONCE_DEFAULT_TEMPLATE?.replace('{{USERNAME}}', this.gitlab.account.username).replace('{{TOKEN}}', this.gitlab.account.token) ?? ''
            },
            baseFiles: JSON.parse(process.env.ENONCE_BASE_FILES || '[]'),
            filename : process.env.ENONCE_FILENAME || ''
        };

        this.exercice = {
            maxSameName  : Number(process.env.EXERCICE_MAX_SAME_NAME || 0),
            resultsFolder: process.env.EXERCICE_RESULTS_FOLDER ?? '', //Do not use convertWithEnvVars() because it is used in the exercice creation and muste be interpreted at exercice runtime
            default      : {
                description: process.env.EXERCICE_DEFAULT_DESCRIPTION?.convertWithEnvVars() ?? '',
                visibility : process.env.EXERCICE_DEFAULT_VISIBILITY || GitlabVisibility.PRIVATE
            }
        };

        this.userPasswordLength = Number(process.env.USER_PASSWORD_LENGTH || 0);
        this.userPasswordSaltRounds = Number(process.env.USER_PASSWORD_SALT_ROUNDS || 10);
    }
}


export default new Config();
