import { Express }    from 'express-serve-static-core';
import RoutesManager  from '../express/RoutesManager';
import BaseRoutes     from './BaseRoutes';
import SessionRoutes  from './SessionRoutes';
import EnonceRoutes   from './EnonceRoutes';
import GitlabRoutes   from './GitlabRoutes';
import ExerciceRoutes from './ExerciceRoutes';


class AdminRoutesManager implements RoutesManager {
    registerOnBackend(backend: Express) {
        BaseRoutes.registerOnBackend(backend);
        SessionRoutes.registerOnBackend(backend);
        GitlabRoutes.registerOnBackend(backend);
        EnonceRoutes.registerOnBackend(backend);
        ExerciceRoutes.registerOnBackend(backend);
    }
}


export default new AdminRoutesManager();
