import { Express }        from 'express-serve-static-core';
import express            from 'express';
import RoutesManager      from '../express/RoutesManager';
import SecurityMiddleware from '../middlewares/SecurityMiddleware';
import SecurityCheckType  from '../types/SecurityCheckType';
import GitlabManager      from '../managers/GitlabManager';


class EnonceRoutes implements RoutesManager {
    registerOnBackend(backend: Express) {
        backend.get('/gitlab/project/:idOrNamespace/checkTemplateAccess', SecurityMiddleware.check(true, SecurityCheckType.TEACHING_STAFF), this.checkTemplateAccess);
    }

    private async checkTemplateAccess(req: express.Request, res: express.Response) {
        const idOrNamespace: string = req.params.idOrNamespace;

        return res.status(await GitlabManager.checkTemplateAccess(idOrNamespace, req)).send();
    }
}


export default new EnonceRoutes();
