require('./InitialImports'); // ATTENTION : These lines MUST be the first of this file

import WorkerRole     from './process/WorkerRole';
import ClusterManager from './process/ClusterManager';
import API            from './express/API';
import HttpManager    from './managers/HttpManager';


HttpManager.registerAxiosInterceptor();


(new ClusterManager([ {
    role         : WorkerRole.API,
    quantity     : ClusterManager.CORES,
    restartOnFail: true,
    loadTask     : () => new API()
} ])).run();
