import Config        from '../config/Config';
import GitlabRelease from '../shared/types/Gitlab/GitlabRelease';
import GitlabManager from '../managers/GitlabManager';


class DojoCliVersionHelper {
    private latestUpdate: Date | undefined;
    private latestVersion: string | undefined;

    private async updateVersion(): Promise<void> {
        const releases: Array<GitlabRelease> = await GitlabManager.getRepositoryReleases(Config.dojoCLI.repositoryId);
        for ( const release of releases ) {
            if ( !isNaN(+release.tag_name.replace('.', '')) ) {
                this.latestVersion = release.tag_name;
                this.latestUpdate = new Date();
                return;
            }
        }
    }

    public async getLatestVersion(): Promise<string> {
        if ( !this.latestVersion || !this.latestUpdate || (new Date()).getTime() - this.latestUpdate.getTime() >= Config.dojoCLI.versionUpdatePeriodMs ) {
            await this.updateVersion();
        }

        return this.latestVersion!;
    }
}


export default new DojoCliVersionHelper();