import express            from 'express';
import Config             from '../config/Config';
import semver             from 'semver/preload';
import Session            from '../controllers/Session';
import { HttpStatusCode } from 'axios';
import DojoStatusCode     from '../shared/types/Dojo/DojoStatusCode';


class ClientVersionCheckerMiddleware {
    register(): (req: express.Request, res: express.Response, next: express.NextFunction) => void {
        return async (req: express.Request, res: express.Response, next: express.NextFunction) => {
            if ( req.headers['client'] && req.headers['client-version'] ) {
                const requestClient = req.headers['client'] as string;
                const requestClientVersion = req.headers['client-version'] as string;

                for ( const [ client, condition ] of Object.entries(Config.requestClientValidation.version) ) {
                    if ( requestClient === client ) {
                        if ( semver.satisfies(semver.valid(semver.coerce(requestClientVersion)) || '0', condition) ) {
                            next();
                            return;
                        } else {
                            new Session().sendResponse(res, HttpStatusCode.MethodNotAllowed, {}, `Client version ${ requestClientVersion } is not supported. Please update your client.`, DojoStatusCode.CLIENT_VERSION_NOT_SUPPORTED);
                            return;
                        }
                    }
                }

                new Session().sendResponse(res, HttpStatusCode.MethodNotAllowed, {}, `Unsupported client.`, DojoStatusCode.CLIENT_NOT_SUPPORTED);
            }
        };
    }
}


export default new ClientVersionCheckerMiddleware();