// Read from the .env file
// ATTENTION : This lines MUST be the first of this file (except for the path import)
const path = require('node:path');

if ( process.env.NODE_ENV && process.env.NODE_ENV === 'production' ) {
    require('dotenv').config();
} else {
    require('dotenv').config({ path: path.join(__dirname, '../.env.keys') });
    require('dotenv').config({ DOTENV_KEY: process.env.DOTENV_KEY_DEVELOPMENT });
}

require('./shared/helpers/TypeScriptExtensions'); // ATTENTION : This line MUST be after the dotenv.config() calls

import WorkerRole     from './process/WorkerRole';
import ClusterManager from './process/ClusterManager';
import API            from './express/API';
import HttpManager    from './managers/HttpManager';


HttpManager.registerAxiosInterceptor();


(new ClusterManager([ {
    role         : WorkerRole.API,
    quantity     : ClusterManager.CORES,
    restartOnFail: true,
    loadTask     : () => {
        return new API();
    }
} ])).run();
