import { Prisma }    from '@prisma/client';
import Config        from '../../../config/Config';
import LazyVal       from '../../../shared/helpers/LazyVal';
import GitlabUser    from '../../../shared/types/Gitlab/GitlabUser';
import GitlabManager from '../../../managers/GitlabManager';


export default Prisma.defineExtension(client => {
    return client.$extends({
                               result: {
                                   user: {
                                       isTeachingStaff: {
                                           needs: {
                                               role: true
                                           },
                                           compute(user) {
                                               return Config.permissions.teachingStaff.includes(user.role!);
                                           }
                                       },
                                       gitlabProfile  : {
                                           needs: {
                                               gitlabId: true
                                           },
                                           compute(user) {
                                               return new LazyVal<GitlabUser | undefined>(() => {
                                                   return GitlabManager.getUserById(user.gitlabId);
                                               });
                                           }
                                       }
                                   }
                               }
                           });
});