import express          from 'express';
import GitlabRepository from '../shared/types/Gitlab/GitlabRepository';
import logger           from '../shared/logging/WinstonLogger';
import GitlabManager    from '../managers/GitlabManager';
import { AxiosError }   from 'axios';
import { StatusCodes }  from 'http-status-codes';
import DojoStatusCode   from '../shared/types/Dojo/DojoStatusCode';


class GlobalHelper {
    async repositoryCreationError(message: string, error: unknown, req: express.Request, res: express.Response, gitlabError: DojoStatusCode, internalError: DojoStatusCode, repositoryToRemove?: GitlabRepository): Promise<void> {
        logger.error(message);
        logger.error(error);

        try {
            if ( repositoryToRemove ) {
                await GitlabManager.deleteRepository(repositoryToRemove.id);
            }
        } catch ( error ) {
            logger.error('Repository deletion error');
            logger.error(error);
        }

        if ( error instanceof AxiosError ) {
            return req.session.sendResponse(res, StatusCodes.INTERNAL_SERVER_ERROR, {}, `Unknown gitlab error: ${ message }`, gitlabError);
        }

        return req.session.sendResponse(res, StatusCodes.INTERNAL_SERVER_ERROR, {}, `Unknown error: ${ message }`, internalError);
    }
}


export default new GlobalHelper();