import { Prisma }   from '@prisma/client';
import { Exercise } from '../types/DatabaseTypes';
import db           from '../helpers/DatabaseHelper';


class ExerciseManager {
    async get(id: string, include: Prisma.ExerciseInclude | undefined = undefined): Promise<Exercise | undefined> {
        return await db.exercise.findUnique({
                                                where  : {
                                                    id: id
                                                },
                                                include: include
                                            }) as unknown as Exercise ?? undefined;
    }
}


export default new ExerciseManager();
